/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.hyperlink;

import com.aptana.console.AdaptingHyperlink;
import com.aptana.core.logging.IdeLog;
import com.aptana.terminal.hyperlink.IHyperlinkDetector;
import com.aptana.workbench.hyperlink.EditorLineHyperlink;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.radrails.rails.ui.RailsUIPlugin;

public class RenderPathHyperlinkDetector
implements IHyperlinkDetector,
IConsoleLineTracker {
    private static Pattern RENDERED_VIEW_PATTERN = Pattern.compile("^Rendered\\s+(\\S.+?)\\s+");
    private static Pattern GENERATOR_CREATED_PATTERN = Pattern.compile("^\\s+(identical|exists|create(\\s+mode\\s+\\d+)?)\\s+(\\S.+?)\\s*$");
    private IConsole fConsole;

    public IHyperlink[] detectHyperlinks(String contents) {
        Matcher m = RENDERED_VIEW_PATTERN.matcher(contents);
        if (m.find()) {
            String filepath = m.group(1);
            int start = m.start(1);
            int length = m.end(1) - start;
            if (!filepath.startsWith("/")) {
                filepath = "app/views/" + filepath;
            }
            return new IHyperlink[]{new EditorLineHyperlink(new Region(start, length), filepath, 0)};
        }
        m = GENERATOR_CREATED_PATTERN.matcher(contents);
        if (m.find()) {
            String filepath = m.group(3);
            int start = m.start(3);
            int length = m.end(3) - start;
            return new IHyperlink[]{new EditorLineHyperlink(new Region(start, length), filepath, 0)};
        }
        return new IHyperlink[0];
    }

    public void init(IConsole console) {
        this.fConsole = console;
    }

    public void lineAppended(IRegion line) {
        if (this.fConsole == null) {
            return;
        }
        try {
            IHyperlink[] links;
            String contents = this.fConsole.getDocument().get(line.getOffset(), line.getLength());
            IHyperlink[] iHyperlinkArray = links = this.detectHyperlinks(contents);
            int n = links.length;
            int n2 = 0;
            while (n2 < n) {
                IHyperlink link = iHyperlinkArray[n2];
                IRegion region = link.getHyperlinkRegion();
                this.fConsole.addLink((org.eclipse.ui.console.IHyperlink)new AdaptingHyperlink(link), region.getOffset() + line.getOffset(), region.getLength());
                ++n2;
            }
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)RailsUIPlugin.getDefault(), (Throwable)e);
        }
    }

    public void dispose() {
        this.fConsole = null;
    }
}

